



<html>
<head>
  <title>javabog.dk - Webprogrammering med Java Server Pages - Inde i webserveren</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel6.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel8.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">7 <a name='afsn7'></a>Inde i
webserveren</H1>
<DIV ID="Indholdsfortegnelse8">
  <P STYLE="margin-top: 0.5cm; margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>7.1
  Servletter  135</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">7.1.1
  Anmodningsmetoder  137</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">7.1.2
  Hvorn&aring;r bruge JSP og hvorn&aring;r bruge servletter  137</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>7.2
  Installation af en servlet  138</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">7.2.1
  Flere URLer til samme servlet  138</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">7.2.2
  Avanceret: Automatisk binding af servletter  139</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>7.3
  Avanceret: JSP-siders interne virkem&aring;de  139</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">7.3.1
  Kigge i de genererede servletter  139</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">7.3.2
  Eksempel  139</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">7.3.3
  JSP-siders livscyklus  141</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>7.4
  Webapplikationer  142</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">7.4.1
  Pakkede webapplikationer (WAR-filer)  142</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>7.5
  Samlet driftsbeskrivelse (web.xml)  143</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>7.6
  Test dig selv  146</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>7.7
  Resum&eacute;  146</B></FONT></FONT></P>
</DIV>













<P CLASS="kapiteloversigt-western">Dette kapitel er frivillig
l&aelig;sning; det foruds&aelig;ttes ikke i resten af bogen. 
</P>
<P CLASS="kapiteloversigt-western">Det foruds&aelig;tter <a href='kapitel3.jsp'>kapitel 3</a>,
Interaktive sider, og <a href='kapitel5.jsp'>kapitel 5</a>, Brug af databaser.</P>
<P CLASS="western" STYLE="">Dette kapitel
handler om konfiguration af webserveren og nogle af de ting, der sker
&quot;under motorhjelmen&quot;, inde i webserveren.</P>
<H2 CLASS="western">7.1 <a name='afsn7.1'></a>Servletter</SPAN></H2>
<P CLASS="western">En servlet er en Java-klasse, der bliver brugt af
en webserver. Den har noget programkode, der opbygger et
HTML-dokument, som bliver sendt til klienten. 
</P>
<P CLASS="western">Her er en servlet, der udskriver det samme som
JSP-siden syvtabellen.jsp (fra <a href='kapitel2.jsp#afsn2.2.1'>afsnit 2.2.1</a>, Indlejrede java-udtryk):</P>
<PRE CLASS="kode-western">import <SPAN LANG="da-DK">java.io.</SPAN>*;
import javax.servlet.*;
import javax.servlet.http.*;
<SPAN LANG="da-DK">public</SPAN> <SPAN LANG="da-DK">class</SPAN> <SPAN LANG="da-DK">SimpelServlet</SPAN> <B><SPAN LANG="da-DK">extends</SPAN> <SPAN LANG="da-DK">HttpServlet</SPAN></B>
{
  public void doGet(<B>HttpServletRequest request</B>, 
<SPAN STYLE="font-weight: medium">                    </SPAN><B>HttpServletResponse response</B><SPAN STYLE="font-weight: medium">) </SPAN><SPAN LANG="da-DK">throws</SPAN> <SPAN LANG="da-DK">IOException</SPAN>
  {
<SPAN STYLE="font-weight: medium">    <SPAN LANG="da-DK">response.setContentType</SPAN>(&quot;text/html&quot;);</SPAN>
    <SPAN LANG="da-DK">PrintWriter</SPAN> out = <SPAN LANG="da-DK">response.getWriter</SPAN>();
<SPAN STYLE="font-weight: medium">    out.println(&quot;</SPAN><B>&lt;html&gt;</B>&quot;);
<SPAN STYLE="font-weight: medium">    </SPAN>out.println(<B>&quot;&lt;head&gt;&lt;title&gt;Syvtabellen - fra en servlet&lt;/title&gt;&lt;/head&gt;</B>&quot;);
<SPAN STYLE="font-weight: medium">    </SPAN>out.println(<B>&quot;&lt;body&gt;</B>&quot;);
<SPAN STYLE="font-weight: medium">    </SPAN>out.println(<B>&quot;&lt;p&gt;Her er syv-tabellen:&lt;br&gt;</B>&quot;);
 
    for (int i=1; i&lt;=10; i++)
    {
      out.println(&quot;<B>Syv gange &quot;+ i +&quot; er: &quot;+ 7*i +&quot;.&lt;br&gt;</B>&quot;);
    } 
<SPAN STYLE="font-weight: medium">    </SPAN>out.println(&quot;<B>&lt;/body&gt;</B>&quot;);
<SPAN STYLE="font-weight: medium">    </SPAN>out.println(&quot;<B>&lt;/html&gt;</B>&quot;);
  }
}</PRE><P CLASS="western" ALIGN=CENTER>
<IMG SRC="bog8_html_m28c222ff.png" NAME="Grafik20" ALIGN=BOTTOM BORDER=0></P>

<P CLASS="western" STYLE="">L&aelig;g m&aelig;rke
til:</P>
<UL>
  <LI><P CLASS="western" STYLE="font-weight: medium"><SPAN LANG="da-DK">Servlet-klassen</SPAN>
  skal arve fra HttpServlet</P>
  <LI><P CLASS="western"><SPAN STYLE="font-weight: medium">Servletten
  skal have en doGet(<SPAN LANG="da-DK">request</SPAN>,
  response)-metode<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A></SPAN></P>
  <LI><P CLASS="western" STYLE="font-weight: medium">Ud fra
  response-objektet f&aring;r man et out-objekt, som man kan bruge til
  at skrive HTML-kode til klienten/netl&aelig;seren.</P>
</UL>
<P CLASS="western">Uddata fra en servlet er som regel HTML, men kan
egentlig v&aelig;re af enhver slags. Servletten kan sende andre slags
data, e.v.t. bin&aelig;re, eller viderestille til en anden adresse.</P>
<P CLASS="western">N&aring;r webserveren f&aring;r en anmodning om en
URL, der svarer til servlettens navn<A CLASS="sdfootnoteanc" NAME="sdfootnote2anc" HREF="#sdfootnote2sym"><SUP>2</SUP></A>,
kalder den metoden doGet() p&aring; servletten (allerf&oslash;rste
gang opretter serveren et objekt af den p&aring;g&aelig;ldende
klasse). Denne metode f&aring;r overf&oslash;rt alle relevante
oplysninger om anmodningen i et r<SPAN STYLE="font-weight: medium">equest-objekt
og skal s&aring; ud</SPAN>fylde et response-objekt med svaret til
klienten.</P>
<P CLASS="western">For at afpr&oslash;ve servletten (forudsat vi har
oversat til bin&aelig;r kode og installeret det i en webserver)
kalder vi f.eks. adressen
<A CLASS="western" HREF="http://localhost:8080/JSP/servlet/SimpelServlet">http://localhost:8080/JSP/servlet/SimpelServlet</A>
op i en netl&aelig;ser (man ser at servlettens navn normalt indg&aring;r
i URLen).</P>
<H3 CLASS="western">7.1.1 <a name='afsn7.1.1'></a>Anmodningsmetoder</H3>
<P CLASS="western">Som diskuteret i <a href='kapitel3.jsp#afsn3.6.4'>afsnit 3.6.4</a>, Skjule parametrene (POST-metoden),
findes der flere metoder en netl&aelig;ser kan tage i anvendelse, n&aring;r
den skal foretage en foresp&oslash;rgsel (GET og POST).</P>
<P CLASS="western">GET-anmodninger for&aring;rsager at servlettens
doGet<SPAN STYLE="font-weight: medium">(request, response)</SPAN>-metode
bliver kaldt.</P>
<P CLASS="western">Tilsvarende for&aring;rsager POST-anmodninger, at
metoden <SPAN LANG="da-DK">doPost<SPAN STYLE="font-weight: medium">(request,
response)</SPAN></SPAN> kaldes.</P>
<P CLASS="western">Ofte er man dog ligeglad med, om anmodninger
kommer med den ene eller anden metode og s&aring; lader man blot
doPost() kalde doGet(), som s&aring; g&oslash;r arbejdet:</P>
<PRE CLASS="kode-western"><SPAN STYLE="font-weight: medium">  </SPAN>public void doPost(HttpServletRequest request, 
                    HttpServletResponse response) throws IOException
  {
    doGet(request, response);
  }</PRE><P CLASS="western">
Hvilken anmodningsmetode, der bruges, kan altid ses med
request.getMethod().</P>
<H3 CLASS="western">7.1.2 <a name='afsn7.1.2'></a>Hvorn&aring;r bruge JSP og hvorn&aring;r
bruge servletter</H3>
<P CLASS="western">Servletter er som sagt javakode (Java-klasser),
der genererer HTML-kode. 
</P>
<P CLASS="western">JSP er p&aring; en m&aring;de det omvendte:
HTML-kode med indlejret Javakode.</P>
<P CLASS="western">Er du i tvivl om du skal bruge JSP-sider eller
servletter til en given opgave, s&aring; er her et par betragtninger,
du kan tage med i dine overvejelser:</P>
<UL>
  <LI><P CLASS="western">Som enhver anden Java-klasse skal en servlets
  .java-fil overs&aelig;ttes til en bin&aelig;r .class-fil, som skal
  l&aelig;gges i WEB-INF/classes/</P>
  <LI><P CLASS="western">Alle servletter skal n&aelig;vnes i
  WEB-INF/web.xml (se <a href='kapitel7.jsp#afsn7.2'>afsnit 7.2</a>, Installation af en servlet)</P>
  <LI><P CLASS="western">JSP-sider kan genkendes og redigeres visuelt
  i de fleste <SPAN LANG="da-DK">ordentlige</SPAN>
  HTML-redigeringsv&aelig;rkt&oslash;jer. Det vil sige, at man ikke
  beh&oslash;ver at skrive al HTML-koden selv.</P>
  <LI><P CLASS="western">Servletter kan, som alle andre klasser,
  genkendes og redigeres af Java-udviklingsv&aelig;rkt&oslash;jer.
  V&aelig;rkt&oslash;jerne kan dog ikke hj&aelig;lpe dig med at lave
  HTML-koden i servletten.</P>
</UL>
<P CLASS="western">Alt i alt er servletter mest velegnede til
indviklet <SPAN LANG="da-DK">programlogik, mens JSP-sider er
velegnede, hvis der skal </SPAN>produceres meget HTML til klienten.
Er du begynder, b&oslash;r du nok v&aelig;lge JSP-sider, da de er
lettest at komme i gang med.</P>
<H2 CLASS="western">7.2 <a name='afsn7.2'></a>Installation af en servlet</SPAN></H2>
<P CLASS="western"><SPAN STYLE="font-weight: medium">F&oslash;r du
kan k&oslash;re en servlet, skal du angive servlet-klassen, der</SPAN>
svarer til en URL p&aring; <SPAN STYLE="font-weight: medium">webserveren.
Det g&oslash;res i filen web.xml (der skal ligge i mappen WEB-INF),
hvor der skal st&aring;:</SPAN></P>
<OL>
  <LI><P CLASS="western" STYLE="font-weight: medium">Navnet p&aring;
  servletten i &lt;servlet-name&gt;</P>
  <LI><P CLASS="western" STYLE="font-weight: medium">Klassenavnet
  (incl. pakkenavn) i &lt;servlet-class&gt;</P>
  <LI><P CLASS="western"><SPAN STYLE="font-weight: medium">Hvilke(n)
  URL(er) </SPAN>p&aring; serveren der skal omdirigeres til servletten
  i &lt;url-pattern&gt; i en &lt;servlet-mapping&gt;</P>
</OL>
<P CLASS="western"><SPAN STYLE="font-weight: medium">Her er et uddrag
af web.xml. G</SPAN>ennem navnet &quot;En simpel servlet&quot; bindes
klassen <SPAN STYLE="font-weight: medium">SimpelServlet</SPAN> til
URLen /servlet/<SPAN STYLE="font-weight: medium">SimpelServlet</SPAN>:</P>
<PRE CLASS="kode-western">&lt;web-app&gt;
<SPAN LANG="da-DK">  ...</SPAN>
<SPAN LANG="da-DK">  &lt;servlet&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;servlet-name&gt;En simpel servlet&lt;/servlet-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;servlet-class&gt;<SPAN STYLE="font-weight: medium">SimpelServlet</SPAN>&lt;/servlet-class&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/servlet&gt;</SPAN>

<SPAN LANG="da-DK">  &lt;servlet-mapping&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;servlet-name&gt;En simpel servlet&lt;/servlet-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;url-pattern&gt;/servlet/<SPAN STYLE="font-weight: medium">SimpelServlet</SPAN>&lt;/url-pattern&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/servlet-mapping&gt;</SPAN>
<SPAN LANG="da-DK">  ...</SPAN>
<SPAN LANG="da-DK">&lt;/web-app&gt;</SPAN></PRE><H3 CLASS="western">
7.2.1 <a name='afsn7.2.1'></a>Flere URLer til samme servlet</H3>
<P CLASS="western"><SPAN LANG="da-DK">Denne sy<SPAN STYLE="font-weight: medium">ntaks
l&oslash;sriver klassenavnet fra URLen og giver dermed mulighed for
mange </SPAN>fikse m&aring;der at s&aelig;tte sin webapplikation op
p&aring;.</SPAN></P>
<P CLASS="western">Vi kunne f.eks. sende alle foresp&oslash;rgsler
til /simpel/* til vores SimpelServlet ved at tilf&oslash;je:</P>
<PRE CLASS="kode-western">  &lt;servlet-mapping&gt;
<SPAN LANG="da-DK">    &lt;servlet-name&gt;<B>En simpel servlet</B>&lt;/servlet-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;url-pattern&gt;<B>/simpel/*</B>&lt;/url-pattern&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/servlet-mapping&gt;</SPAN></PRE><P CLASS="western">
<SPAN LANG="da-DK">Herefter ville f.eks.
</SPAN><A CLASS="western" HREF="http://localhost:8080/JSP/simpel/hvad.som.helst"><SPAN LANG="da-DK">http://localhost:8080/JSP/simpel/hvad.som.helst</SPAN></A><SPAN LANG="da-DK">
f&aring; webserveren til at kalde SimpelServlet. </SPAN>
</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog8_html_m24c1274b.png" NAME="Grafik31" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western">Et praktisk eksempel p&aring;, hvor dette kunne
v&aelig;re nyttigt, findes i <a href='kapitel10.jsp#afsn10.5.3'>afsnit 10.5.3</a>, Eksempel p&aring; en Frontkontrol.</P>
<H3 CLASS="western" STYLE="">7.2.2 <a name='afsn7.2.2'></a>Avanceret:
Automatisk binding af servletter</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel7.jsp#afsn7.2.2">
  <input type='checkbox' name='vis' value='7.2.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.2.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">7.3 <a name='afsn7.3'></a>Avanceret: JSP-siders interne virkem&aring;de</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel7.jsp#afsn7.3">
  <input type='checkbox' name='vis' value='7.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">7.3.1 <a name='afsn7.3.1'></a>Kigge i de genererede servletter</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel7.jsp#afsn7.3.1">
  <input type='checkbox' name='vis' value='7.3.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.3.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">7.3.2 <a name='afsn7.3.2'></a>Eksempel</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel7.jsp#afsn7.3.2">
  <input type='checkbox' name='vis' value='7.3.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.3.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">7.3.3 <a name='afsn7.3.3'></a>JSP-siders livscyklus</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel7.jsp#afsn7.3.3">
  <input type='checkbox' name='vis' value='7.3.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.3.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<H2 CLASS="western" STYLE="">7.4 <a name='afsn7.4'></a>Webapplikationer</SPAN></H2>
<P CLASS="western"><IMG SRC="bog8_html_5d6f405f.png" NAME="Grafik53" ALIGN=RIGHT HSPACE=4 BORDER=0>En
<I>webapplikation</I> er en gruppe websider, der h&oslash;rer sammen.
En webserver kan godt have flere webapplikationer k&oslash;rende
samtidig og oprette/installere, fjerne og opdatere webapplikationer
uafh&aelig;ngigt af hinanden.</P>
<P CLASS="western">P&aring; harddisken har serveren normalt hver
webapplikation liggende i en separat mappe. I Tomcat ligger disse
mapper under webapps/.</P>
<P CLASS="western">P&aring; billedet til h&oslash;jre kan man p&aring;
mappestrukturen se, at der er installeret 5 webapplikationer, nemlig
&quot;JSP&quot;, &quot;jsp-examples&quot;, &quot;ROOT&quot;,
&quot;servlet-examples&quot; og &quot;tomcat-docs&quot;.</P>
<P CLASS="western">Disse kan findes under en URL, der svarer til
navnet. F.eks. ligger webapplikationen &quot;jsp-examples&quot; p&aring;
<A CLASS="western" HREF="http://localhost:8080/jsp-examples/">http://localhost:8080/jsp-examples/</A>
(eneste undtagelse er ROOT som ligger i roden, p&aring;
<A CLASS="western" HREF="http://localhost:8080/">http://localhost:8080</A>
). 
</P>
<P CLASS="western">HTML- og JSP-sider, billeder etc. ligger som filer
i webapplikationens mappe. I den specielle undermappe WEB-INF/ ligger
alle andre filer:</P>
<P CLASS="western">I <B>WEB-INF/classes</B> skal dine egne klasser
ligge.</P>
<P CLASS="western">I <B>WEB-INF/lib</B> skal du l&aelig;gge JAR-filer
med funktioner, der bruges i dine JSP-sider.</P>
<P CLASS="western">I <B>WEB-INF/web.xml</B> skal driftsbeskrivelsen
til serveren ligge (se <a href='kapitel7.jsp#afsn7.5'>afsnit 7.5</a>).</P>
<P CLASS="western"><SPAN LANG="da-DK">Nogen gange kan filstrukturen
afvige fra, hvad man forventer ud fra URLen, fordi det st&aring;r
angivet i WEB-INF/w</SPAN>eb.xml (se <a href='kapitel7.jsp#afsn7.2'>afsnit 7.2</a>). Det g&aelig;lder
is&aelig;r servletter. S&aring;ledes kunne <SPAN STYLE="font-weight: medium"><SPAN LANG="da-DK">SimpelServlet</SPAN></SPAN>,
der ligger webapplikationen &quot;JSP&quot; i filen
WEB-INF/classes/<SPAN STYLE="font-weight: medium"><SPAN LANG="da-DK">SimpelServlet.class</SPAN></SPAN>,
v&aelig;re afbildet over p&aring; URL-adressen
<A CLASS="western" HREF="http://localhost:8080/JSP/servlet/SimpelServlet">http://localhost:8080/JSP/<SPAN LANG="da-DK">servlet/<SPAN STYLE="font-weight: medium">SimpelServlet</SPAN></SPAN></A><SPAN STYLE="font-weight: medium"><SPAN LANG="da-DK">
</SPAN></SPAN>.</P>

<H3 CLASS="western">7.4.1 <a name='afsn7.4.1'></a>Pakkede webapplikationer (WAR-filer)</H3>
<P CLASS="western">En webapplikation kan v&aelig;re pakket ned i en
WAR-fil (Web ARchive), der er en ZIP-fil med en mappestruktur, der
svarer til, hvordan filerne skal ligge p&aring; serveren. 
</P>
<H4 CLASS="western">Installere en WAR-fil</H4>
<P CLASS="western">En WAR-fil kan kopieres ind i mappen webapps i
Tomcat. Derefter vil webserveren selv  pakke den ud og idrifts&aelig;tte
den. 
</P>
<P CLASS="western">P&aring; billedet ovenfor kan man nederst se
hvordan WAR-filen JSP.war er blevet kopieret til webapps/JSP.war,
hvorefter webserveren har pakket ud i webapps/JSP/ , s&aring; den er
tilg&aelig;ngelig p&aring; adressen <A CLASS="western" HREF="http://localhost:8080/JSP/">http://localhost:8080/JSP/</A>.</P>
<H4 CLASS="western">Lave en WAR-fil</H4>
<P CLASS="western"><SPAN LANG="da-DK">Selvom princippet i WAR-filer
egentlig er enkelt nok, er der mange, der til at starte med, har
problemer med at lave WAR-filer. Bruger du et u</SPAN>dviklingsv&aelig;rkt&oslash;j,
b&oslash;r du se, om det kan hj&aelig;lpe dig med at generere
WAR-filen. Ellers er det nemmeste ofte, at tage en eksisterende
WAR-fil (tjek at den virker!) og erstatte filerne i den med dine
egne.</P>
<P CLASS="western">Filstrukturen og mappestrukturen i en WAR-fil skal
v&aelig;re pr&aelig;cist som den p&aring; harddisken, is&aelig;r skal
man huske at WEB-INF/ <I>skal</I> ligge i roden af ZIP-filen. Her er
et eksempel: 
</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog8_html_50994dc2.png" NAME="Grafik60" ALIGN=BOTTOM BORDER=0></P>

<H2 CLASS="western">7.5 <a name='afsn7.5'></a><SPAN LANG="da-DK">Samlet driftsbeskrivelse
(</SPAN>web.xml)</SPAN></H2>
<P CLASS="western">Det er i webapplikationens WEB-INF/web.xml man
beskriver, hvordan serveren skal k&oslash;re ens webapplikation i
drift. 
</P>
<P CLASS="western">Her ses hvordan driftsbeskrivelsen web.xml samlet
ser ud for eksemplerne til denne bog.</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>web.xml
- driftsbeskrivelse for webapplikationen</I></FONT></P>
<PRE CLASS="kode-western">&lt;?xml version=&quot;1.0&quot; encoding=&quot;ISO-8859-1&quot;?&gt;
<SPAN LANG="da-DK">&lt;web-app xmlns=&quot;http://java.sun.com/xml/ns/j2ee&quot;</SPAN>
<SPAN LANG="da-DK">    xmlns:xsi=&quot;http://www.w3.org/2001/XMLSchema-instance&quot;</SPAN>
<SPAN LANG="da-DK">    xsi:schemaLocation=&quot;http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd&quot;</SPAN>
<SPAN LANG="da-DK">    version=&quot;2.4&quot;&gt;</SPAN>

<SPAN LANG="da-DK"><I>  &lt;!-- Samlet eksempel p&aring; konfigurationsfil for en webapplikation.</I></SPAN>
<SPAN LANG="da-DK"><I>       Filnavn: /WEB-INF/web.xml</I></SPAN>
<SPAN LANG="da-DK"><I>    --&gt;</I></SPAN>

<SPAN LANG="da-DK">  &lt;display-name&gt;Eksempler fra javabog.dk&lt;/display-name&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;description&gt;Alle eksemplerne fra bogen &quot;Webprogrammering med Java Server Pages&quot;,</SPAN>
<SPAN LANG="da-DK">    der ogs&aring; kan l&aelig;ses p&aring; http://javabog.dk/JSP&lt;/description&gt;</SPAN>

<SPAN LANG="da-DK">  <I>&lt;!-- ================================================================</I></SPAN>
<I><SPAN LANG="da-DK">       Eksempler p&aring; initialiseringsparametre - se <a href='kapitel4.jsp#afsn4.5.5'>afsnit 4.5.5</a> i bogen</SPAN></I>
<SPAN LANG="da-DK"><I>       Afl&aelig;s med f.eks: application.getInitParameter(&quot;dbDriver&quot;)</I></SPAN>
<SPAN LANG="da-DK"><I>       ================================================================ --&gt; </I></SPAN>
  &lt;c<SPAN LANG="da-DK">ontext-param</SPAN>&gt;
    &lt;description<SPAN LANG="da-DK">&gt;Driveren til databasen&lt;/description&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;param-name&gt;dbDriver&lt;/param-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;param-value&gt;com.mysql.jdbc.Driver&lt;/param-value&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/context-param&gt;</SPAN>

<SPAN LANG="da-DK">  &lt;context-param&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;description&gt;Adressen (URLen) p&aring; databasen&lt;/description&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;param-name&gt;dbUrl&lt;/param-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;param-value&gt;jdbc:mysql:///test&lt;/param-value&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/context-param&gt;</SPAN>

<SPAN LANG="da-DK">  &lt;context-param&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;description&gt;Brugernavnet til databasen&lt;/description&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;param-name&gt;dbBruger&lt;/param-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;param-value&gt;root&lt;/param-value&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/context-param&gt;</SPAN>

<SPAN LANG="da-DK">  &lt;context-param&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;description&gt;Adgangskoden til databasen&lt;/description&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;param-name&gt;dbAdgangskode&lt;/param-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;param-value&gt;&lt;/param-value&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/context-param&gt;</SPAN>
<SPAN LANG="da-DK"> </SPAN>
<SPAN LANG="da-DK"><I>  &lt;!-- Denne initialiseringsparameter er til JSTLs databasetags i <a href='kapitel6.jsp#afsn6.3'>afsnit 6.3</a> --&gt;</I></SPAN>
<SPAN LANG="da-DK">  &lt;context-param&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;param-name&gt;javax.servlet.jsp.jstl.sql.dataSource&lt;/param-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;param-value&gt;jdbc:mysql:///test,com.mysql.jdbc.Driver&lt;/param-value&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/context-param&gt;</SPAN>

<SPAN LANG="da-DK"><I>  &lt;!-- Disse initialiseringsparametre er til Login-b&oslash;nnen i <a href='kapitel9.jsp#afsn9.5'>afsnit 9.5</a> --&gt;</I></SPAN>
<SPAN LANG="da-DK">  &lt;context-param&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;description&gt;SMTP-server for epost fra Login-b&oslash;nnen i <a href='kapitel9.jsp#afsn9.5'>afsnit 9.5</a>&lt;/description&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;param-name&gt;postserver&lt;/param-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;param-value&gt;post.tele.dk&lt;/param-value&gt;  <I>&lt;!-- TDC som internetudbyder --&gt;</I></SPAN>
<SPAN LANG="da-DK">  &lt;/context-param&gt;</SPAN>

<SPAN LANG="da-DK">  &lt;context-param&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;description&gt;Afsenderadressen for Login-b&oslash;nnen i <a href='kapitel9.jsp#afsn9.5'>afsnit 9.5</a>&lt;/description&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;param-name&gt;postafsender&lt;/param-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;param-value&gt;din@adresse.dk&lt;/param-value&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/context-param&gt;</SPAN>

<SPAN LANG="da-DK">  <I>&lt;!-- ================================================================</I></SPAN>
<I><SPAN LANG="da-DK">       Indstillinger til <a href='kapitel7.jsp#afsn7.1'>afsnit 7.1</a>, Servletter</SPAN></I>
<SPAN LANG="da-DK"><I>       ================================================================ --&gt; </I></SPAN>
<SPAN LANG="da-DK">  &lt;servlet&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;servlet-name&gt;En simpel servlet&lt;/servlet-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;servlet-class&gt;SimpelServlet&lt;/servlet-class&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/servlet&gt;</SPAN>

<SPAN LANG="da-DK">  &lt;servlet-mapping&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;servlet-name&gt;En simpel servlet&lt;/servlet-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;url-pattern&gt;/servlet/SimpelServlet&lt;/url-pattern&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/servlet-mapping&gt;</SPAN>
<SPAN LANG="da-DK"> </SPAN>
<SPAN LANG="da-DK"><I>  &lt;!-- Alle foresp&oslash;rgsler til /simpel/* sendes til vores SimpelServlet --&gt; </I></SPAN>
<SPAN LANG="da-DK">  &lt;servlet-mapping&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;servlet-name&gt;En simpel servlet&lt;/servlet-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;url-pattern&gt;/simpel/*&lt;/url-pattern&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/servlet-mapping&gt;</SPAN>

<SPAN LANG="da-DK"><I>  &lt;!-- Bind alle klasser (herunder ogs&aring; servletter) til /servlet/Klassenavn --&gt;</I></SPAN>
<SPAN LANG="da-DK"><I>  &lt;!-- Kommenteret bort af sikkerhedshensyn</I></SPAN>
<SPAN LANG="da-DK"><I>  &lt;servlet&gt;</I></SPAN>
<SPAN LANG="da-DK"><I>    &lt;servlet-name&gt;invoker&lt;/servlet-name&gt;</I></SPAN>
<SPAN LANG="da-DK"><I>    &lt;servlet-class&gt;org.apache.catalina.servlets.InvokerServlet&lt;/servlet-class&gt;</I></SPAN>
<SPAN LANG="da-DK"><I>  &lt;/servlet&gt;</I></SPAN>
<SPAN LANG="da-DK"><I>  </I></SPAN>
<SPAN LANG="da-DK"><I>  &lt;servlet-mapping&gt;</I></SPAN>
<SPAN LANG="da-DK"><I>     &lt;servlet-name&gt;invoker&lt;/servlet-name&gt;</I></SPAN>
<SPAN LANG="da-DK"><I>     &lt;url-pattern&gt;/servlet/*&lt;/url-pattern&gt;</I></SPAN>
<SPAN LANG="da-DK"><I>  &lt;/servlet-mapping&gt;</I></SPAN>
<SPAN LANG="da-DK"><I>  --&gt;</I></SPAN>


<SPAN LANG="da-DK">  <I>&lt;!-- ================================================================</I></SPAN>
<I><SPAN LANG="da-DK">       Indstillinger til <a href='kapitel8.jsp#afsn8.2'>afsnit 8.2</a>, Adgangskontrol</SPAN></I>
<SPAN LANG="da-DK"><I>       ================================================================ --&gt; </I></SPAN>
<SPAN LANG="da-DK"><I>  &lt;!-- De roller, der er aktuelle for webapplikationen --&gt;</I></SPAN>
<SPAN LANG="da-DK">  &lt;security-role&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;role-name&gt;kunde&lt;/role-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;role-name&gt;administrator&lt;/role-name&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/security-role&gt;</SPAN>

<SPAN LANG="da-DK">  <I>&lt;!-- En gruppe sider med adgangbegr&aelig;nsning --&gt;</I></SPAN>
<SPAN LANG="da-DK">  &lt;security-constraint&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;display-name&gt;Sikkerhedsbegraensning i <a href='kapitel8.jsp'>kapitel 8</a>&lt;/display-name&gt;</SPAN>

<SPAN LANG="da-DK">    <I>&lt;!-- Pr&aelig;cist hvilke sider, der er omfattet af adgangbegr&aelig;nsningen --&gt;</I></SPAN>
<SPAN LANG="da-DK">    &lt;web-resource-collection&gt;</SPAN>
<SPAN LANG="da-DK">      &lt;url-pattern&gt;/kode/kapitel_08/beskyttet_side.jsp&lt;/url-pattern&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;/web-resource-collection&gt;</SPAN>

<SPAN LANG="da-DK">    <I>&lt;!-- Hvilke brugerroller har adgang til de p&aring;g&aelig;ldende sider --&gt;</I></SPAN>
<SPAN LANG="da-DK">    &lt;auth-constraint&gt;</SPAN>
<SPAN LANG="da-DK">      &lt;role-name&gt;kunde&lt;/role-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;role-name&gt;administrator&lt;/role-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;/auth-constraint&gt;</SPAN>

<I>    &lt;!-- Hvordan skal data sendes over netv&aelig;rket --&gt;</I>
<I>    &lt;!-- Mulighederne er: NONE, INTEGRAL og CONFIDENTIAL (kr&aelig;ver SSL)</I>
<I>    &lt;user-data-constraint&gt;</I>
<I>      &lt;transport-guarantee&gt;CONFIDENTIAL&lt;/transport-guarantee&gt;</I>
<I>    &lt;/user-data-constraint&gt;   </I>
<I>    --&gt;</I>
  &lt;/security-constraint&gt;  

<I>  &lt;!-- Brugeren skal identificeres med en login-formular --&gt;</I>
  &lt;login-config&gt;
    &lt;auth-method&gt;FORM&lt;/auth-method&gt; 
    &lt;form-login-config&gt;
      &lt;form-login-page&gt;/kode/kapitel_0<SPAN LANG="da-DK">8</SPAN>/loginside.jsp&lt;/form-login-page&gt;     
      &lt;form-error-page&gt;/kode/kapitel_0<SPAN LANG="da-DK">8</SPAN>/fejlagtig_login.jsp&lt;/form-error-page&gt;  
    &lt;/form-login-config&gt;
<SPAN LANG="da-DK"><I>    &lt;!-- Andre muligheder er (giver et loginvindue i stedet for login-formular)</I></SPAN>
<SPAN LANG="da-DK"><I>    &lt;auth-method&gt;BASIC&lt;/auth-method&gt; </I></SPAN>
<SPAN LANG="da-DK"><I>    &lt;auth-method&gt;DIGEST&lt;/auth-method&gt; </I></SPAN>
<SPAN LANG="da-DK"><I>    &lt;auth-method&gt;CLIENT-CERT&lt;/auth-method&gt; </I></SPAN>
<SPAN LANG="da-DK"><I>    --&gt;</I></SPAN>
<SPAN LANG="da-DK">  &lt;/login-config&gt;  </SPAN>


<SPAN LANG="da-DK">  <I>&lt;!-- ================================================================</I></SPAN>
<I><SPAN LANG="da-DK">       Indstillinger til <a href='kapitel10.jsp'>kapitel 10</a>, Arkitekturer i webprogrammering</SPAN></I>
<SPAN LANG="da-DK"><I>       ================================================================ --&gt; </I></SPAN>

<SPAN LANG="da-DK"><I>  &lt;!-- Foresp&oslash;rgsler til /kode/kapitel_10/ sendes til kontrol.jsp --&gt; </I></SPAN>
<SPAN LANG="da-DK">  &lt;servlet&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;servlet-name&gt;Kontrolloer&lt;/servlet-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;jsp-file&gt;/kode/kapitel_10/kontrol.jsp&lt;/jsp-file&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/servlet&gt;</SPAN>

<SPAN LANG="da-DK">  &lt;servlet-mapping&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;servlet-name&gt;Kontrolloer&lt;/servlet-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;url-pattern&gt;/kode/kapitel_10/&lt;/url-pattern&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/servlet-mapping&gt;</SPAN>

<SPAN LANG="da-DK"><I>  &lt;!-- Frontkontrol: Alt der starter med /bank sendes til kontrol.jsp --&gt;</I></SPAN>
<SPAN LANG="da-DK">  &lt;servlet&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;servlet-name&gt;Frontkontrol&lt;/servlet-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;jsp-file&gt;/WEB-INF/bank/kontrol.jsp&lt;/jsp-file&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/servlet&gt;</SPAN>

<SPAN LANG="da-DK">  &lt;servlet-mapping&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;servlet-name&gt;Frontkontrol&lt;/servlet-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;url-pattern&gt;/bank/*&lt;/url-pattern&gt;         <I>&lt;!-- Bem&aelig;rk: * i URL-m&oslash;nster --&gt;</I></SPAN>
<SPAN LANG="da-DK">  &lt;/servlet-mapping&gt;</SPAN>

<SPAN LANG="da-DK">&lt;/web-app&gt;</SPAN></PRE>
<H2 CLASS="western">7.6 <a name='afsn7.6'></a>Test dig selv</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel7.jsp#afsn7.6">
  <input type='checkbox' name='vis' value='7.6'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.6'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">7.7 <a name='afsn7.7'></a>Resum&eacute;</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel7.jsp#afsn7.7">
  <input type='checkbox' name='vis' value='7.7'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='7.7'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <DIV ID="sdfootnote1">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>Man
  kan <SPAN STYLE="font-weight: medium">ogs&aring; definere andre
  metoder, se senere.</SPAN></P>
</DIV>
<DIV ID="sdfootnote2">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote2sym" HREF="#sdfootnote2anc">2</A>I
  <a href='kapitel7.jsp#afsn7.2'>afsnit 7.2</a> vil vi se, hvordan man binder en servlet til en URL.</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel6.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel8.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b>Webprogrammering med Java Server Pages</b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (72% af vrket).
</font>
<br>
nsker du at se de sidste 28% af dette vrk (275315 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
